from myapp.config import Config
from unittest import TestCase

def test_config_has_string_filename_param():
    config = Config()
    filename = config.get_param("filename")

    assert type(filename) == str
    assert type(filename) != int

def test_raise_if_param_does_not_exist():
    config = Config()

    with TestCase.assertRaises(config, RuntimeError):
        config_value = config.get_param("unexisting_param")