from myapp.mylibrary import is_prime
import pytest


def test_is_prime_is_true():
    result = is_prime(2)

    assert result is True

def test_is_prime_is_false():
    result = is_prime(6)

    assert result is False

@pytest.mark.parametrize(
    argnames=('value', 'expected_result'),
    argvalues=[
        (0, True),
        (1, True),
        (2, True),
        (3, True),
        (4, False),
        (5, True),
        (6, False),
        (7, True),
        (8, False),
        (9, False),
        (10, False),
    ],
)
def test_is_prime(value: int, expected_result: bool):
    result = is_prime(value)

    assert result is expected_result

